<?php

	/**
	 * Simple template engine class (use [@tag] tags in your templates).
	 *
	 * @link http://www.broculos.net/ Broculos.net Programming Tutorials
	 * @author Nuno Freitas <nunofreitas@gmail.com>
	 * @version 1.0
	 */
    class Template {

        protected $file;

        protected $values = array();

        public function __construct($file) {
            $this->file = $file;
        }

        public function set($key, $value) {
            $this->values[$key] = $value;
        }

        public function output() {

//            if (!file_exists($this->file)) {
            if (!isset($this->file)) {
            	return "Error al cargar datos ($this->file).<br />";
            }
//            $output = file_get_contents($this->file);
            $output = $this->file;

            foreach ($this->values as $key => $value) {
	            $key = Valida_utf8($key);
	            $key = str_replace('<', '<?php echo \'<\'; ?>', $key);
            	$tagToReplace = "[@$key]";
            	$output = str_replace($tagToReplace, $value, $output);
            }
		//$pattern_clean = '#[\@\]#';
		$pattern_clean = array('#(\@)\w+(\@)#is','#(\[\@)\w+(\])#is');
		//$pattern_clean = '#.*\[\@(.*?)\].*#is';
	    $output = preg_replace($pattern_clean, "", $output);
            return $output;
        }

        static public function merge($templates, $separator = "\n") {

            $output = "";

            foreach ($templates as $template) {
            	$content = (get_class($template) !== "Template")
            		? "Error, tipo incorrecto de datos."
            		: $template->output();
            	$output .= $content . $separator;
            }

            return $output;
        }
}
?>